<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerPublic_InlineMod_ProfilePost extends XFCP_sonnbStopSpamHere_ControllerPublic_InlineMod_ProfilePost
{
	public function actionDeleteSpam()
	{
		$sonnbSSHInlineModel = $this->getModelFromCache('sonnbStopSpamHere_Model_Inline');
		$sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
		
		if ($this->isConfirmedPost())
		{
			$options = $this->_input->filter(array(
			    'thread_action' => XenForo_Input::STRING,
			    'reason' => XenForo_Input::STRING,
			    'node_id' => XenForo_Input::UINT,
			        
				'delete_messages' => XenForo_Input::UINT,
				'delete_profile_post' => XenForo_Input::UINT,
				'user_action' => XenForo_Input::STRING,
				'ip_action' => XenForo_Input::STRING,
				'profilePosts' => array('array' => true, XenForo_Input::UINT),
				'redirect' => XenForo_Input::STRING,
				'submit_spam' => XenForo_Input::ARRAY_SIMPLE
			));

			list($profilePosts, $users) = $this->getModelFromCache('XenForo_Model_InlineMod_ProfilePost')->getProfilePostsAndParentData($options['profilePosts']);
			
			$ownerCount = array();
			foreach ($profilePosts AS $profilePost)
			{				
			    if ($profilePost['user_id'] == $sshModel->visitor['user_id'])
			    {
			        return $this->responseRedirect(
        				XenForo_ControllerResponse_Redirect::SUCCESS,
        				$options['redirect'],
        				new XenForo_Phrase('sorry_dave')
        			);
			    }
			    	
				if (!isset($ownerCount[$profilePost['user_id']]))
				{
					$ownerCount[$profilePost['user_id']] = $profilePost['user_id'];
				}
			}
			
			foreach ($ownerCount as $userId)
			{
				switch ($options['user_action'])
				{
					case 'delete':
						$sonnbSSHInlineModel->deleteUser($userId);
						break;
					case 'ban':
						$sonnbSSHInlineModel->banUser($userId);
						break;
					case 'discourage':
						$sonnbSSHInlineModel->discourageUser($userId);
						break;
					case 'nothing':
					default:
						break;
				}
				
				switch ($options['ip_action'])
				{
					case 'ban':
						$sonnbSSHInlineModel->banUserIPs($userId);
						break;
					case 'discourage':
						$sonnbSSHInlineModel->discourageUserIPs($userId);
						break;
					case 'nothing':
					default:
						break;
				}
					
				/*
				 * Delete all user's profile posts
				 */
				if ($options['delete_profile_post'])
				{
					$sonnbSSHInlineModel->deleteAllUserProfilePosts($userId);
				}
				
				if ($options['user_action'] != 'delete')
				{
					/*
					 * Process all user's threads
					 */
					switch ($options['thread_action'])
					{
					    case 'soft':
					    case 'hard':
						    $sonnbSSHInlineModel->deleteAllUserThreads($userId, $options['thread_action'], $options['reason']);
						    break;
					    case 'move':
					        $sonnbSSHInlineModel->moveAllUserThreads($userId, $options['node_id']);
					        break;
					    case 'nothing':
					    default:
					        break;					        
					}
					
					/*
					 * Delete all user's posts
					 */
					if ($options['delete_messages'])
					{
						$sonnbSSHInlineModel->deleteAllUserPosts($userId);
					}
				}
				
				if ($options['submit_spam'])
				{
					$sonnbSSHInlineModel->submitUserByUserId($userId, $options['submit_spam']);
				}
			
				$sonnbSSHInlineModel->logDeleteSpamForUser($userId, $options);
			}
					
			/*
			 * Delete post only if mass deletion actions were not performed
			 */
			if (!$options['delete_profile_post'])
			{
				$sonnbSSHInlineModel->deleteProfilePost($profilePosts, $users);
			}
			
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$options['redirect'],
				new XenForo_Phrase('sonnbStopSpamHere_your_action_was_performed_successful')
			);
		}
		else // show confirmation dialog
		{
			$profilePostIds = $this->getInlineModIds();

			$handler = $this->_getInlineModProfilePostModel();
			if (!$handler->canDeleteProfilePosts($profilePostIds, 'soft', $errorPhraseKey))
			{
				throw $this->getErrorOrNoPermissionResponseException($errorPhraseKey);
			}

			$redirect = $this->getDynamicRedirect();

			if (!$profilePostIds)
			{
				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					$redirect
				);
			}
			
			list($profilePosts, $users) = $this->getModelFromCache('XenForo_Model_InlineMod_ProfilePost')->getProfilePostsAndParentData($profilePostIds);
			
			$ownerCount = array();
			foreach ($profilePosts AS $profilePost)
			{			
				if (!isset($ownerCount[$profilePost['user_id']]))
				{
					$ownerCount[$profilePost['user_id']] = $profilePost['user_id'];
				}
			}
			
			$showUserInfo = count($ownerCount) == 1;
			
			$viewParams = array(
				'profilePostIds' => $profilePostIds,
				'profilePostCount' => count($profilePostIds),
				'redirect' => $redirect,
				'showUserInfo' => $showUserInfo,
			    'nodeOptions' => $this->getModelFromCache('XenForo_Model_Node')->getViewableNodeList(),
				'services' => array_keys($sshModel->services)
			);
			
			if ($showUserInfo)
			{
				$userModel = $this->getModelFromCache('XenForo_Model_User');
				$profilePost = reset($profilePosts);
				$user = $userModel->getUserById($profilePost['user_id'], array('join' => XenForo_Model_User::FETCH_LAST_ACTIVITY));
				
				if ($user)
				{
					$registrationIps = $userModel->getRegistrationIps($user['user_id']);
					$userIps = $sonnbSSHInlineModel->getUserIps($user['user_id']);
					
					$viewParams['user'] = $user;
					$viewParams['registrationIps'] = $registrationIps;
					$viewParams['lastLoginIp'] = reset($userIps);
				}
			}

			return $this->responseView(
					'sonnbStopSpamHere_ViewPublic_InlineMod_ProfilePost_Delete', 
					'sonnbStopSpamHere_inline_delete', 
					$viewParams
				);
		}
	}

}